module counter

//	**************************************************************************************************
//
//	Open a dialog that displays a number that can be incremented and decremented using two buttons.
//
//	The program has been written in Clean 1.3.1 and uses the Clean Standard Object I/O library 1.0.1
//	
//	**************************************************************************************************

import StdEnv, StdIO

::	NoState	= NoState

Start :: *World -> *World
Start world
	=	startIO NoState NoState [initIO] [] world

initIO ps
	#	(windowid, ps)	= accPIO openId ps
	#	(displayid,ps)	= accPIO openId ps
	#	(_,ps)			= openDialog NoState (dialog windowid displayid) ps
	=	ps
where
	dialog windowId displayId
		=	Dialog "Counter" 
				{	newLS	= init
				,	newDef	=	EditControl (toString init)	displaywidth displayheight 
									[	ControlPos			(Center,zero)
									,	ControlId			displayId
									,	ControlSelectState	Unable
									]
							:+:	ButtonControl "-" 
									[	ControlPos			(Center,zero)
									,	ControlFunction		(upd (-1))
									]
							:+:	ButtonControl "+"
									[	ControlFunction		(upd 1)
									]
				}
				[	WindowClose	(noLS closeProcess)
				,	WindowId	windowId
				]
	where
		displaywidth	= 200
		displayheight	= 1
		init			= 0
		
		upd :: Int (Int,PSt .l .p) -> (Int,PSt .l .p)
		upd dx (count,ps)
			#	count	= count+dx
			=	(count,appPIO (setWindow windowId [setControlTexts [(displayId,toString count)]]) ps)
